<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'unit_id', 'price_usd', 'is_active'];

    // Relación: Un producto pertenece a una unidad de medida
    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
}