<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id', 
        'user_id', 
        'sale_date', 
        'bcv_rate', 
        'total_usd', 
        'total_ves', 
        'notes'
    ];

    // Convertir sale_date a objeto fecha automáticamente
    protected $casts = [
        'sale_date' => 'date',
    ];

    // Relación: Pertenece a un Cliente
    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    // Relación: Pertenece a un Usuario (el vendedor)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relación: Una venta tiene muchos detalles (productos)
    public function details()
    {
        return $this->hasMany(SaleDetail::class);
    }
}