<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Panel de Control') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 text-gray-900">
                    <h3 class="text-2xl font-bold text-gray-800">¡Hola de nuevo! 👋</h3>
                    <p class="text-gray-600">¿Qué te gustaría hacer hoy en la pastelería?</p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                
                <a href="{{ route('sales') }}" class="block p-6 bg-gradient-to-r from-indigo-500 to-indigo-700 rounded-lg shadow-lg transform hover:scale-105 transition duration-300">
                    <div class="flex items-center">
                        <div class="p-3 bg-white bg-opacity-20 rounded-full">
                            💰
                        </div>
                        <div class="ml-4">
                            <h4 class="text-xl font-bold text-white">Nueva Venta</h4>
                            <p class="text-indigo-100 text-sm">Registrar pedido o facturar</p>
                        </div>
                    </div>
                </a>

                <a href="{{ route('products') }}" class="block p-6 bg-white border border-gray-200 rounded-lg shadow-md hover:bg-gray-50 transition">
                    <div class="flex items-center">
                        <div class="p-3 bg-orange-100 text-orange-600 rounded-full">
                            🍰
                        </div>
                        <div class="ml-4">
                            <h4 class="text-lg font-bold text-gray-800">Inventario</h4>
                            <p class="text-gray-500 text-sm">Gestionar productos y precios</p>
                        </div>
                    </div>
                </a>

                <a href="{{ route('analytics') }}" class="block p-6 bg-white border border-gray-200 rounded-lg shadow-md hover:bg-gray-50 transition">
                    <div class="flex items-center">
                        <div class="p-3 bg-purple-100 text-purple-600 rounded-full">
                            🧠
                        </div>
                        <div class="ml-4">
                            <h4 class="text-lg font-bold text-gray-800">Inteligencia</h4>
                            <p class="text-gray-500 text-sm">Alertas de clientes</p>
                        </div>
                    </div>
                </a>

            </div>

        </div>
    </div>
</x-app-layout>