<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;

// Importamos los componentes Livewire (FALTABA REPORTS)
use App\Livewire\Products;
use App\Livewire\Clients;
use App\Livewire\Sales;
use App\Livewire\Reports;        // <--- Faltaba esta línea
use App\Livewire\ClientAnalytics;

Route::get('/', function () {
    return view('welcome');
});

// Grupo de rutas protegidas (requieren login)
Route::middleware(['auth', 'verified'])->group(function () {
    
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // --- TUS MÓDULOS DE PASTELERÍA ---
    
    // 1. Inventario
    Route::get('/productos', Products::class)->name('products');

    // 2. Clientes
    Route::get('/clientes', Clients::class)->name('clients');

    // 3. Ventas
    Route::get('/ventas', Sales::class)->name('sales');

    // 4. Reportes (ESTA ERA LA QUE FALTABA)
    Route::get('/reportes', Reports::class)->name('reports');

    // 5. Inteligencia
    Route::get('/inteligencia', ClientAnalytics::class)->name('analytics');
});

// Rutas de perfil de usuario
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';